/****** Object:  StoredProcedure [dbo].[P_PDV_VD_IT_FIDELIDADE_PONTUAR_FILIAL]    Script Date: 11/08/2013 16:34:57 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_IT_FIDELIDADE_PONTUAR_FILIAL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PDV_VD_IT_FIDELIDADE_PONTUAR_FILIAL]
GO
GO
GO

--EXEC P_PDV_VD_IT_FIDELIDADE_PONTUAR_FILIAL 1,3, '2016-06-15', '2016-06-15',1
CREATE PROCEDURE [dbo].[P_PDV_VD_IT_FIDELIDADE_PONTUAR_FILIAL] (@CD_EMP INT, 
																@CD_FILIAL INT, 
																@DT_INI DATETIME, 
																@DT_FIM DATETIME,
																@FLAG_REPROCESSAR INT=0) WITH ENCRYPTION AS

SET NOCOUNT ON
DECLARE 
	@CD_VD       INT, 
	@CD_INT      INT, 
	@ENVIO       INT, 
	@VLR_PONTOS  MONEY, 
	@CD_USU      INT, 
	@DT_CAD      DATETIME, 
	@QTDE_PONTOS MONEY,
	@NR_ECF		 INT,
	@CD_PROD     INT

IF @FLAG_REPROCESSAR=0
begin
DECLARE cPontosProcessar CURSOR FAST_FORWARD READ_ONLY FOR 
SELECT
	PDV_VD_IT.CD_EMP,
	PDV_VD_IT.CD_FILIAL,
	PDV_VD_IT.CD_VD,
	PDV_VD.NR_ECF,
	PDV_VD_IT.CD_PROD,
	PDV_VD_IT.CD_IT,
	0,
	(PDV_VD_IT.TOT_IT / EST_PROD_CPL.QTDE_PONTO_FIDEL),
	PDV_VD.CD_USU,
	PDV_VD.DT_VD,
	EST_PROD_CPL.QTDE_PONTO_FIDEL 
FROM
	PDV_VD INNER JOIN PDV_VD_IT ON
	PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP AND
	PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND
	PDV_VD.CD_VD = PDV_VD_IT.CD_VD
	LEFT OUTER JOIN PDV_VD_IT_FIDELI_CARTAO ON
	PDV_VD_IT.CD_EMP = PDV_VD_IT_FIDELI_CARTAO.CD_EMP AND
	PDV_VD_IT.CD_FILIAL = PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL AND
	PDV_VD_IT.CD_VD = PDV_VD_IT_FIDELI_CARTAO.CD_VD AND
	PDV_VD_IT.CD_IT = PDV_VD_IT_FIDELI_CARTAO.CD_IT
	INNER JOIN RC_CLI ON
	PDV_VD.CD_EMP = RC_CLI.CD_EMP AND
	PDV_VD.CD_CLI = RC_CLI.CD_CLI
	INNER JOIN EST_PROD_CPL ON
	PDV_VD_IT.CD_EMP = EST_PROD_CPL.CD_EMP AND
	PDV_VD_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL AND
	PDV_VD_IT.CD_PROD = EST_PROD_CPL.CD_PROD 
WHERE
	PDV_VD.CD_EMP = @CD_EMP
	AND PDV_VD.CD_FILIAL = @CD_FILIAL
	AND PDV_VD.DT_VD BETWEEN @DT_INI AND @DT_FIM
	AND PDV_VD_IT_FIDELI_CARTAO.CD_VD IS NULL
	AND RC_CLI.FLAG_CLI_FIDEL = 1 
	AND EST_PROD_CPL.QTDE_PONTO_FIDEL <> 0
	AND (TP_CONS_FINAL + CONS_FINAL = 0)
	AND PDV_VD_IT.ST_IT = 1
end

IF @FLAG_REPROCESSAR=1
begin
DECLARE cPontosProcessar CURSOR FAST_FORWARD READ_ONLY FOR 
SELECT
	PDV_VD_IT.CD_EMP,
	PDV_VD_IT.CD_FILIAL,
	PDV_VD_IT.CD_VD,
	PDV_VD.NR_ECF,
	PDV_VD_IT.CD_PROD,
	PDV_VD_IT.CD_IT,
	0,
	(PDV_VD_IT.TOT_IT / EST_PROD_CPL.QTDE_PONTO_FIDEL),
	PDV_VD.CD_USU,
	PDV_VD.DT_VD,
	EST_PROD_CPL.QTDE_PONTO_FIDEL 
FROM
	PDV_VD INNER JOIN PDV_VD_IT ON
	PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP AND
	PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND
	PDV_VD.CD_VD = PDV_VD_IT.CD_VD
	INNER JOIN PDV_VD_IT_FIDELI_CARTAO ON
	PDV_VD_IT.CD_EMP = PDV_VD_IT_FIDELI_CARTAO.CD_EMP AND
	PDV_VD_IT.CD_FILIAL = PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL AND
	PDV_VD_IT.CD_VD = PDV_VD_IT_FIDELI_CARTAO.CD_VD AND
	PDV_VD_IT.CD_IT = PDV_VD_IT_FIDELI_CARTAO.CD_IT
	INNER JOIN RC_CLI ON
	PDV_VD.CD_EMP = RC_CLI.CD_EMP AND
	PDV_VD.CD_CLI = RC_CLI.CD_CLI
	INNER JOIN EST_PROD_CPL ON
	PDV_VD_IT.CD_EMP = EST_PROD_CPL.CD_EMP AND
	PDV_VD_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL AND
	PDV_VD_IT.CD_PROD = EST_PROD_CPL.CD_PROD 
WHERE
	PDV_VD.CD_EMP = @CD_EMP
	AND PDV_VD.CD_FILIAL = @CD_FILIAL
	AND PDV_VD.DT_VD BETWEEN @DT_INI AND @DT_FIM
	AND RC_CLI.FLAG_CLI_FIDEL = 1 
	AND EST_PROD_CPL.QTDE_PONTO_FIDEL <> 0
	AND EST_PROD_CPL.QTDE_PONTO_FIDEL <> PDV_VD_IT_FIDELI_CARTAO.QTDE_PONTO_FIDEL
	AND (TP_CONS_FINAL + CONS_FINAL = 0)
	AND PDV_VD_IT.ST_IT = 1
end
				
print 'Carregou cursor de pontos pendentes - Time : ' +convert(varchar,getdate(),108) 

OPEN cPontosProcessar
FETCH NEXT FROM cPontosProcessar INTO	@CD_EMP,@CD_FILIAL,@CD_VD,@NR_ECF,@CD_PROD,@CD_INT,@ENVIO,@VLR_PONTOS,@CD_USU,@DT_CAD,@QTDE_PONTOS


WHILE @@FETCH_STATUS=0
BEGIN 
	PRINT 'Codigo filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' ' + CONVERT(VARCHAR, GETDATE (),108) + ' ECF.: ' + CONVERT(VARCHAR(50),@NR_ECF) + ' Produto.: ' + CONVERT(VARCHAR(50),@CD_PROD)
	IF @FLAG_REPROCESSAR=0
	begin
		INSERT INTO PDV_VD_IT_FIDELI_CARTAO (cd_emp,cd_filial,cd_vd,cd_it,envio_fidel,VLR_PONTO_IT,cd_usu,dt_cad,QTDE_PONTO_FIDEL,ID_CLI_FIDEL,CD_TBL_FIDEL)
		SELECT 
			@CD_EMP, 
			@CD_FILIAL, 
			@CD_VD, 
			@CD_INT, 
			@ENVIO, 
			@VLR_PONTOS, 
			@CD_USU, 
			@DT_CAD, 
			@QTDE_PONTOS,
			'',
			0
	end

	IF @FLAG_REPROCESSAR=1
	begin
		UPDATE
			PDV_VD_IT_FIDELI_CARTAO
		SET 
			ENVIO_FIDEL=@ENVIO, 
			VLR_PONTO_IT=@VLR_PONTOS, 
			QTDE_PONTO_FIDEL=@QTDE_PONTOS
		WHERE
			CD_EMP =@CD_EMP 
			AND CD_FILIAL=@CD_FILIAL 
			AND CD_VD=@CD_VD 
			AND CD_IT=@CD_INT
			AND QTDE_PONTO_FIDEL<>@QTDE_PONTOS

		update
			RC_CLI_FIDELI_PONTOS_CREDITO
		set 
             RC_CLI_FIDELI_PONTOS_CREDITO.QTDE_PONTOS=@VLR_PONTOS
		FROM            
			RC_CLI_FIDELI_PONTOS_CREDITO INNER JOIN RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO v ON 
			RC_CLI_FIDELI_PONTOS_CREDITO.CD_CTR_PONTOS = v.CD_CTR_PONTOS
		WHERE
			v.CD_EMP =@CD_EMP 
			AND v.CD_FILIAL=@CD_FILIAL 
			AND v.CD_VD=@CD_VD 
			AND v.CD_IT=@CD_INT
			AND RC_CLI_FIDELI_PONTOS_CREDITO.QTDE_PONTOS<>@VLR_PONTOS
	end
	FETCH NEXT FROM cPontosProcessar INTO	@CD_EMP,@CD_FILIAL,@CD_VD,@NR_ECF,@CD_PROD,@CD_INT,@ENVIO,@VLR_PONTOS,@CD_USU,@DT_CAD,@QTDE_PONTOS
END
CLOSE cPontosProcessar
DEALLOCATE cPontosProcessar 
print 'Fim de atualizacao de pontos - Time : ' +convert(varchar,getdate(),108) 

GO


